/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.common.util;

import com.ibm.hsc.cim.exceptions.HSCCIMException;
import com.ibm.hsc.common.util.HscCecLock;
import com.ibm.hsc.common.util.HscGroupLock;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class HscLockManager {
    private static Hashtable lockMgrTable = new Hashtable();
    private Hashtable lockTable = new Hashtable();
    private Hashtable taskPolicyTable = new Hashtable();
    private String lockMgrId;
    private Hashtable grpLocks = new Hashtable();
    private static HscLockManager hscProviderLockManager;
    static String[][] taskPolicy;

    private HscLockManager(String string) {
        this.lockMgrId = string;
    }

    public static HscLockManager GetHscLockManager(String string) {
        HscLockManager hscLockManager = (HscLockManager)lockMgrTable.get(string);
        if (hscLockManager == null) {
            hscLockManager = new HscLockManager(string);
            lockMgrTable.put(string, hscLockManager);
        }
        return hscLockManager;
    }

    public synchronized HscCecLock getHscCecLock(String string) {
        HscCecLock hscCecLock = (HscCecLock)this.lockTable.get(string);
        if (hscCecLock == null) {
            hscCecLock = new HscCecLock(string);
            this.lockTable.put(string, hscCecLock);
        }
        return hscCecLock;
    }

    public synchronized void removeHscCecLock(String string) {
        this.lockTable.remove(string);
    }

    public synchronized int setGroupLock(int n, Vector vector, int n2) throws HSCCIMException {
        boolean bl = false;
        HscGroupLock hscGroupLock = (HscGroupLock)this.grpLocks.get(Thread.currentThread());
        if (hscGroupLock != null) {
            if (hscGroupLock.lockObjs.equals(vector) && hscGroupLock.locked == hscGroupLock.count) {
                return 1;
            }
            throw new HSCCIMException("32" + "RWLOCK-01: Invalid lock type".substring(7, 8));
        }
        hscGroupLock = HscGroupLock.genGLockObject(this, n, vector, n2);
        this.grpLocks.put(Thread.currentThread(), hscGroupLock);
        if (hscGroupLock.setGlock() == hscGroupLock.count) {
            return 1;
        }
        long l = System.currentTimeMillis();
        while (hscGroupLock.hasGroupLock() != 1) {
            try {
                if (n2 <= 0) {
                    this.wait(1000L);
                    continue;
                }
                this.wait(n2);
                if (System.currentTimeMillis() - l < (long)n2) continue;
                throw new IllegalArgumentException("RWLOCK-02: Failed to acquire lock because of timeout");
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return 1;
    }

    public synchronized void releaseGroupLock() {
        HscGroupLock hscGroupLock = (HscGroupLock)this.grpLocks.remove(Thread.currentThread());
        if (hscGroupLock == null) {
            System.out.println("HscLockManager: to release an unheld GLock");
            throw new IllegalArgumentException("RWLOCK-04: Lock not held");
        }
        hscGroupLock.unsetGlock();
    }

    public int getLockType(String string) {
        int n = 1;
        String string2 = (String)this.taskPolicyTable.get(string.toLowerCase());
        if (string2 == null) {
            System.out.println("Wrong lock type for " + string + ". WRITE lock is used.");
            return n;
        }
        System.out.println("========== Taskname " + string + " found");
        if (string2.equalsIgnoreCase("R")) {
            n = 0;
        } else if (string2.equalsIgnoreCase("W")) {
            n = 1;
        } else if (string2.equalsIgnoreCase("EW")) {
            n = 2;
        } else {
            System.out.println("Wrong lock type for " + string + ". WRITE lock is used.");
        }
        return n;
    }

    public static HscLockManager GetHscProviderLockManager() {
        return hscProviderLockManager;
    }

    public void dump() {
        System.out.println("****************** dump the CEC lock table ************");
        Enumeration enumeration = this.lockTable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            HscCecLock hscCecLock = (HscCecLock)this.lockTable.get(string);
            System.out.println("For cec " + string + ":");
            hscCecLock.print();
            System.out.println("------------------------------------");
        }
        System.out.println("****************** end of dump the CEC lock table ************");
    }

    public static void main(String[] stringArray) {
        System.out.println("The HSC Provider Task Policy: ");
        int n = 0;
        while (n < taskPolicy.length) {
            System.out.println(taskPolicy[n][0] + ", " + taskPolicy[n][1]);
            ++n;
        }
    }

    static {
        taskPolicy = new String[][]{{"createInstance", "W"}, {"enumInstances", "R"}, {"getInstance", "R"}, {"setInstance", "W"}, {"deleteInstance", "W"}, {"execQuery", "R"}, {"PowerOn", "R"}, {"PowerOff", "R"}, {"GetLockOwner", "R"}, {"ReleaseLockOwner", "R"}, {"RebuildCec", "W"}, {"RestoreNVRAM", "W"}, {"PartitionDataRecover", "W"}, {"ActivateSystemProfile", "W"}, {"VirtualTTYRequest", "R"}, {"GetSPErrorLog", "R"}, {"GetHscInfo", "R"}, {"GetNumberOfHscInfoSlot", "R"}, {"GetHostHscInfoSlotID", "R"}, {"HandleEvent", "W"}, {"GetPPARSetupInfo", "R"}, {"SetupPPAR", "W"}, {"RemovePPARSetup", "W"}, {"GetPPARResources", "R"}, {"RemoveReserved", "R"}, {"ActivateLparProfile", "W"}, {"ActivatePartition", "W"}, {"ActivatePartitionWithBootMode", "W"}, {"OSReset", "R"}, {"OpPanelPoller", "W"}, {"getDLPARCPUInfo", "R"}, {"getDLPARMemInfo", "R"}, {"AcceptCUoDAgreement", "R"}, {"CUoDProcessorInfo", "R"}, {"SetCUoDKey", "W"}, {"CPULPARTask", "R"}, {"MemLPARTask", "R"}, {"IOLPARTask", "R"}, {"ValidateSysProfile", "R"}, {"UpdateSystemProfile", "W"}, {"initFrame", "R"}, {"getFrameInfo", "R"}, {"refreshFrame", "W"}, {"powerOffCSP", "R"}, {"resetCSP", "R"}, {"powerOffIO", "R"}};
        hscProviderLockManager = HscLockManager.GetHscLockManager("provider");
        Hashtable hashtable = HscLockManager.hscProviderLockManager.taskPolicyTable;
        int n = 0;
        while (n < taskPolicy.length) {
            hashtable.put(taskPolicy[n][0].toLowerCase(), taskPolicy[n][1].toLowerCase());
            ++n;
        }
    }
}

